/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1998,2004          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */
#ifndef _SAMPLE_FRAME_H
#define _SAMPLE_FRAME_H

static char *Sample_Frame_sccsid = "@(#)45   1.3   src/rsct/pgs/samples/Sample_Frame.h, gssamples, rsct_rzauh, rzauhbase 5/14/01 09:43:35";


#if !defined(_HAGSD_COPYRIGHT_H)
#define _HAGSD_COPYRIGHT_H
static char copyright[] = "Licensed Materials - Property of IBM\n\
(C) COPYRIGHT International Business Machines Corp. 1998,2001.\n\
All Rights Reserved.\n\
US Government Users Restricted Rights - Use, duplication or \n\
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";
#endif

/*********************************************************************/
/*
 * Name:  Sample_Frame.h
 *
 * Define a frame.  Contains a slot for each possible node that may
 * be in the frame, the node in turn contains the providers.
 *
 * See Sample_Subscribe.C for more info.
 */
 /*********************************************************************/

#include "Sample_Subscribe.h"           // Standard includes.

class   Node;

#define NODES_PER_FRAME 16

class   Frame {
  public:

    Frame(int _frame,
          int _slot,
          short _instance,
          unsigned int *_IPaddr,
          ha_gs_adapter_death_t *_death);

    virtual ~Frame(void);

  public:
    // Add a provider into the correct node.  Return number of providers
    // in frame.
    int         Add(short _instance,
                    short _node,
                    unsigned int *_IPaddr,
                    ha_gs_adapter_death_t *_death);

    // Print out the frame.
    void        Print(void);

  private:

    Node       *nodeTable[NODES_PER_FRAME + 1]; // Array of nodes.

    int         count;                  // Number of providers in frame.
    int         myFrameNumber;          // Frame I represent.
    int         highestProvCount;       // Number of providers on node with most.
};

#endif  /* SAMPLE_FRAME_H */
